/*
	    Script che aggiunge nella tabella dei web server alcuni campi aggiunti dopo
		la creazione iniziale necessari al merge della dichiarazione IVA
*/

declare @StrSql			as nvarchar(4000)
-------------------------------------------------------------------------------------------------------------------------
IF NOT EXISTS(SELECT TOP 1 1
              FROM INFORMATION_SCHEMA.COLUMNS
              WHERE TABLE_NAME = 'CGW0_WEBSERVER'
              AND COLUMN_NAME = 'CGW0_FLGFIRMATARIO')
	BEGIN
		set @StrSql = N'ALTER TABLE CGW0_WEBSERVER ADD CGW0_FLGFIRMATARIO TINYINT NOT NULL DEFAULT(0)'
		exec sp_executesql @StrSql

		PRINT 'Tabella CGW0_WEBSERVER: campo CGW0_FLGFIRMATARIO creato'
	END
ELSE
	BEGIN
		PRINT 'Tabella CGW0_WEBSERVER: campo CGW0_FLGFIRMATARIO esistente, creazione non effettuata'
	END
-------------------------------------------------------------------------------------------------------------------------
IF NOT EXISTS(SELECT TOP 1 1
              FROM INFORMATION_SCHEMA.COLUMNS
              WHERE TABLE_NAME = 'CGW0_WEBSERVER'
              AND COLUMN_NAME = 'CGW0_INDMENUPARAM')
	BEGIN
		set @StrSql = N'ALTER TABLE CGW0_WEBSERVER ADD CGW0_INDMENUPARAM INT NOT NULL DEFAULT(0)'
		exec sp_executesql @StrSql

		PRINT 'Tabella CGW0_WEBSERVER: campo CGW0_INDMENUPARAM creato'
	END
ELSE
	BEGIN
		PRINT 'Tabella CGW0_WEBSERVER: campo CGW0_INDMENUPARAM esistente, creazione non effettuata'
	END
-------------------------------------------------------------------------------------------------------------------------
IF NOT EXISTS(SELECT TOP 1 1
              FROM INFORMATION_SCHEMA.COLUMNS
              WHERE TABLE_NAME = 'CGW0_WEBSERVER'
              AND COLUMN_NAME = 'CGW0_ORD')
	BEGIN
		set @StrSql = N'ALTER TABLE CGW0_WEBSERVER ADD CGW0_ORD INT NOT NULL DEFAULT(0)'
		exec sp_executesql @StrSql

		PRINT 'Tabella CGW0_WEBSERVER: campo CGW0_ORD creato'
	END
ELSE
	BEGIN
		PRINT 'Tabella CGW0_WEBSERVER: campo CGW0_ORD esistente, creazione non effettuata'
	END
GO
-------------------------------------------------------------------------------------------------------------------------
IF NOT EXISTS (SELECT * FROM sys.all_columns WHERE object_id = OBJECT_ID(N'CGW0_WEBSERVER') AND name = 'CGW0_PROTOCOLLO')
	BEGIN
		ALTER TABLE CGW0_WEBSERVER ADD CGW0_PROTOCOLLO tinyint NOT NULL DEFAULT 0 

		--' Inserisco nel database la descrizione del nuovo campo creato                                   '
		--'                                                                                                '
		EXEC sp_addextendedproperty 
             @name = N'MS_Description'
           , @value = N'Tipo protocollo utilizzato
            0 = Non dichiarato
            1 = FTP  - File Transfer Protocol
            2 = SFTP - Secure Shell File Transfer Protocol
           '
          , @level0type = N'Schema', @level0name = 'dbo'  
          , @level1type = N'Table',  @level1name = 'CGW0_WEBSERVER'  
          , @level2type = N'Column', @level2name = 'CGW0_PROTOCOLLO'

		PRINT 'Tabella CGW0_WEBSERVER: campo CGW0_PROTOCOLLO creato'
	END
ELSE
	BEGIN
		PRINT 'Tabella CGW0_WEBSERVER: campo CGW0_PROTOCOLLO esistente, creazione non effettuata'
	END
GO
-------------------------------------------------------------------------------------------------------------------------
IF NOT EXISTS (SELECT * FROM sys.all_columns WHERE object_id = OBJECT_ID(N'CGW0_WEBSERVER') AND name = 'CGW0_PORTA')
	BEGIN
		ALTER TABLE CGW0_WEBSERVER ADD CGW0_PORTA int NOT NULL DEFAULT 0 

		--' Inserisco nel database la descrizione del nuovo campo creato                                   '
		--'                                                                                                '
		EXEC sp_addextendedproperty 
             @name = N'MS_Description'
           , @value = N'Porta utilizzata
            0 = Non dichiarata
           '
           , @level0type = N'Schema', @level0name = 'dbo'  
           , @level1type = N'Table',  @level1name = 'CGW0_WEBSERVER'  
           , @level2type = N'Column', @level2name = 'CGW0_PORTA'

		PRINT 'Tabella CGW0_WEBSERVER: campo CGW0_PORTA creato'
	END
ELSE
	BEGIN
		PRINT 'Tabella CGW0_WEBSERVER: campo CGW0_PORTA esistente, creazione non effettuata'
	END	
GO
-------------------------------------------------------------------------------------------------------------------------
